/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.ai;

import insane96mcp.insanelib.utils.RandomHelper;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public class WitherRangedAttackGoal
extends Goal {
    private final WitherEntity wither;
    private LivingEntity target;
    private int attackTime = -1;
    private int seeTime;
    private final int attackInterval;
    private final float attackRadius;
    private final float attackRadiusSqr;
    private final boolean increaseASOnNear;

    public WitherRangedAttackGoal(WitherEntity wither, int attackInterval, float attackRadius, boolean increaseASOnNear) {
        this.wither = wither;
        this.attackInterval = attackInterval;
        this.attackRadius = attackRadius;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.increaseASOnNear = increaseASOnNear;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.wither.func_82212_n() > 0) {
            return false;
        }
        int targetId = this.wither.func_82203_t(0);
        Entity entity = this.wither.field_70170_p.func_73045_a(targetId);
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!livingEntity.func_70089_S()) {
            return false;
        }
        this.target = livingEntity;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.wither.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public void func_75246_d() {
        CompoundNBT witherTags = this.wither.getPersistentData();
        double distanceSq = this.wither.func_70092_e(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_());
        boolean canSee = this.wither.func_70635_at().func_75522_a((Entity)this.target);
        int unseenPlayerTicks = witherTags.func_74762_e("progressivebosses:unseen_player_ticks");
        if (canSee) {
            ++this.seeTime;
            if (unseenPlayerTicks > 0) {
                witherTags.func_74768_a("progressivebosses:unseen_player_ticks", unseenPlayerTicks - 1);
            }
        } else {
            this.seeTime = 0;
            if (this.target instanceof PlayerEntity) {
                witherTags.func_74768_a("progressivebosses:unseen_player_ticks", unseenPlayerTicks + 2);
            }
        }
        if (distanceSq <= (double)this.attackRadiusSqr && this.seeTime > 0) {
            this.wither.func_213293_j(0.0, this.wither.func_213322_ci().field_72448_b, 0.0);
        } else if (this.seeTime <= 0 && !this.wither.field_70170_p.func_180495_p(this.wither.func_233580_cy_().func_177977_b()).func_200132_m() && !this.wither.field_70170_p.func_226660_f_(this.wither.func_233580_cy_())) {
            this.wither.func_213293_j(this.wither.func_213322_ci().field_72450_a, -1.0, this.wither.func_213322_ci().field_72449_c);
        }
        this.wither.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        int barrageAttackTick = witherTags.func_74762_e("progressivebosses:barrage_attack");
        if (barrageAttackTick > 0) {
            if (!canSee) {
                return;
            }
            witherTags.func_74768_a("progressivebosses:barrage_attack", barrageAttackTick - 1);
            if (barrageAttackTick % 3 == 0) {
                this.wither.func_82209_a(RandomHelper.getInt((Random)this.wither.func_70681_au(), (int)0, (int)3), this.target.func_226277_ct_() + RandomHelper.getDouble((Random)this.wither.func_70681_au(), (double)-2.0, (double)2.0), this.target.func_226278_cu_() + (double)this.target.func_70047_e() * 0.5 + RandomHelper.getDouble((Random)this.wither.func_70681_au(), (double)-2.0, (double)2.0), this.target.func_226281_cx_() + RandomHelper.getDouble((Random)this.wither.func_70681_au(), (double)-2.0, (double)2.0), false);
            }
        } else if (--this.attackTime <= 0) {
            float distance;
            if (!canSee) {
                return;
            }
            if (RandomHelper.getFloat((Random)this.wither.func_70681_au(), (float)0.0f, (float)1.0f) < 0.1f) {
                for (int h = 0; h < 3; ++h) {
                    this.wither.func_82209_a(h, this.target.func_226277_ct_() + RandomHelper.getDouble((Random)this.wither.func_70681_au(), (double)-1.25, (double)1.25), this.target.func_226278_cu_() + RandomHelper.getDouble((Random)this.wither.func_70681_au(), (double)-1.25, (double)1.25) + (double)this.target.func_70047_e() * 0.5, this.target.func_226281_cx_() + RandomHelper.getDouble((Random)this.wither.func_70681_au(), (double)-1.25, (double)1.25), RandomHelper.getDouble((Random)this.wither.func_70681_au(), (double)0.0, (double)1.0) < (double)0.001f);
                }
            } else {
                this.wither.func_82209_a(0, this.target.func_226277_ct_(), this.target.func_226278_cu_() + (double)this.target.func_70047_e() * 0.5, this.target.func_226281_cx_(), RandomHelper.getDouble((Random)this.wither.func_70681_au(), (double)0.0, (double)1.0) < (double)0.001f);
            }
            this.attackTime = this.attackInterval;
            if (this.increaseASOnNear && (distance = this.wither.func_70032_d((Entity)this.target)) < this.attackRadius) {
                int nearBonusAS = (int)Math.round((double)this.attackInterval * 0.75 * (1.0 - (double)(distance / this.attackRadius)));
                this.attackTime -= nearBonusAS;
            }
        }
    }
}

